/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class CdDvd
extends MediaDevice {
    CdDvd(MediaDeviceIdentifier id) throws MediaDeviceException {
        super(id);
        Trace.trace("XMDADEVT", "-> CdDvd.CdDvd(MediaDeviceIdentifier = " + id + ")");
        this.mountWithUid = true;
        Trace.trace("XMDADEVT", "<- CdDvd.CdDvd()");
    }

    boolean isMediaPresent() throws MediaDeviceLockException {
        Trace.trace("XMDADEVT", "-> CdDvd.isMediaPresent()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        int rc = -1;
        try {
            String[] isMediaPresentCmd = new String[]{this.mediaServicesParameters.getParm("media.device.check.media.script"), this.mediaDeviceProperties.getDeviceFile(), new Integer(2).toString(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace("XMDADEVF", "CdDvd.isMediaPresent(): isMediaPresentCmd[0] = " + isMediaPresentCmd[0]);
            Trace.trace("XMDADEVF", "CdDvd.isMediaPresent(): isMediaPresentCmd[1] = " + isMediaPresentCmd[1]);
            Trace.trace("XMDADEVF", "CdDvd.isMediaPresent(): isMediaPresentCmd[2] = " + isMediaPresentCmd[2]);
            Trace.trace("XMDADEVF", "CdDvd.isMediaPresent(): isMediaPresentCmd[3] = " + isMediaPresentCmd[3]);
            rc = RootProcess.executeProgram(isMediaPresentCmd);
            Trace.trace("XMDADEVF", "CdDvd.isMediaPresent(): rc = " + rc);
        }
        catch (Exception exc) {
            Trace.trace("XMDADEVF", exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 625, mdexc).log();
        }
        Trace.trace("XMDADEVT", "<- CdDvd.isMediaPresent()");
        return rc == 0;
    }

    public void eject() throws MediaDeviceException {
        Trace.trace("XMDADEVT", "-> CdDvd.eject()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        try {
            String[] ejectCmd = new String[]{this.mediaServicesParameters.getParm("media.eject.script"), this.mediaDeviceProperties.getDeviceFile(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace("XMDADEVF", "CdDvd.eject(): ejectCmd[0] = " + ejectCmd[0]);
            Trace.trace("XMDADEVF", "CdDvd.eject(): ejectCmd[1] = " + ejectCmd[1]);
            Trace.trace("XMDADEVF", "CdDvd.eject(): ejectCmd[2] = " + ejectCmd[2]);
            int rc = RootProcess.executeProgram(ejectCmd);
            Trace.trace("XMDADEVF", "CdDvd.eject(): rc = " + rc);
            if (rc != 0) {
                throw new IOException("failure to eject media");
            }
        }
        catch (Exception exc) {
            Trace.trace("XMDADEVF", exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 626, mdexc).log();
            throw mdexc;
        }
        Trace.trace("XMDADEVT", "<- CdDvd.eject()");
    }

    public String getLabel() throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException {
        Trace.trace("XMDADEVT", "-> CdDvd.getLabel()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (!this.isMediaPresent()) {
            throw new NoMediaPresentException("missing media");
        }
        String label = this.mediaProperties.getLabel(this);
        Trace.trace("XMDADEVT", "<- CdDvd.getLabel(): returns " + label);
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readLabelFile(String labelFile) throws IOException {
        Trace.trace("XMDADEVT", "-> CdDvd.readLabelFile(labelFile = " + labelFile + ")");
        String buffer = null;
        String label = null;
        FileReader tfr = null;
        BufferedReader tbr = null;
        try {
            tfr = new FileReader(labelFile);
            tbr = new BufferedReader(tfr);
            buffer = tbr.readLine();
            if (buffer != null) {
                if (buffer.indexOf("32+0") != -1) {
                    Trace.trace("XMDADEVF", "CdDvd.readLabelFile(): The label file was created with the dd command");
                    StringTokenizer st = new StringTokenizer(buffer);
                    if (st.hasMoreTokens()) {
                        label = st.nextToken();
                        Trace.trace("XMDADEVF", "CdDvd.readLabelFile(): label = " + label);
                        if (label.equals("32+0")) {
                            label = null;
                        }
                    }
                } else {
                    Trace.trace("XMDADEVF", "CdDvd.readLabelFile(): The label file was created with the chkudf command");
                    if (buffer.indexOf("(M) Volume Identifier:") != -1) {
                        String subBuffer = buffer.substring(26, buffer.length() - 1);
                        if (subBuffer.startsWith("0 - ")) {
                            label = buffer.substring(30, buffer.length() - 1);
                            Trace.trace("XMDADEVF", "CdDvd.readLabelFile(): label = " + label);
                        } else {
                            label = subBuffer;
                            Trace.trace("XMDADEVF", "CdDvd.readLabelFile(): label = " + label);
                        }
                    } else {
                        label = null;
                        Trace.trace("XMDADEVF", "CdDvd.readLabelFile(): There is no label present");
                    }
                }
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (tbr != null) {
                    tbr.close();
                }
            }
            catch (IOException ioexc) {
                Trace.trace("XMDADEVF", ioexc);
            }
            throw throwable;
        }
        try {
            if (tbr != null) {
                tbr.close();
            }
        }
        catch (IOException ioexc) {
            Trace.trace("XMDADEVF", ioexc);
        }
        Trace.trace("XMDADEVT", "<- CdDvd.readLabelFile()");
        return label;
    }

    public void lockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "-> CdDvd.lockDriveDoor()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        this.doorLockControl("media.device.lockdoor");
        this.driveDoorLocked = true;
        Trace.trace("XMDADEVT", "<- CdDvd.lockDriveDoor()");
    }

    public void unlockDriveDoor() throws MediaDeviceException, MediaDeviceLockException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "-> CdDvd.unlockDriveDoor()");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        this.doorLockControl("media.device.unlockdoor");
        this.driveDoorLocked = false;
        Trace.trace("XMDADEVT", "<- CdDvd.unlockDriveDoor()");
    }

    private void doorLockControl(String command) throws MediaDeviceException {
        Trace.trace("XMDADEVT", "-> CdDvd.doorLockControl(command = " + command + ")");
        try {
            String[] lockCmd = new String[]{this.mediaServicesParameters.getParm("media.device.lock.script"), this.mediaServicesParameters.getParm(command), this.mediaDeviceProperties.getDeviceFile(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace("XMDADEVF", "CdDvd.doorLockControl(): lockCmd[0] = " + lockCmd[0]);
            Trace.trace("XMDADEVF", "CdDvd.doorLockControl(): lockCmd[1] = " + lockCmd[1]);
            Trace.trace("XMDADEVF", "CdDvd.doorLockControl(): lockCmd[2] = " + lockCmd[2]);
            Trace.trace("XMDADEVF", "CdDvd.doorLockControl(): lockCmd[3] = " + lockCmd[3]);
            int rc = RootProcess.executeProgram(lockCmd);
            Trace.trace("XMDADEVF", "CdDvd.doorLockControl(): rc = " + rc);
            if (rc != 0) {
                throw new IOException("failure to (un)lock media");
            }
        }
        catch (Exception exc) {
            Trace.trace("XMDADEVF", exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 627, mdexc).log();
            throw mdexc;
        }
        Trace.trace("XMDADEVT", "<- CdDvd.doorLockControl()");
    }

    public void format(String label, int fileSystemType) throws MediaDeviceException, MediaDeviceLockException, NoMediaPresentException, IllegalArgumentException, UnsupportedOperationException {
        Trace.trace("XMDADEVT", "-> CdDvd.format(label = " + label + ", " + "fileSystemType = " + fileSystemType + ")");
        if (!this.isLockValid()) {
            throw new MediaDeviceLockException("Operation attempted by task other than the device lock owner.", this.mediaDeviceIdentifier.getCurrentLockOwner());
        }
        if (fileSystemType != 2) {
            throw new IllegalArgumentException("Invalid filesystem type specified to format the DVD-RAM.");
        }
        if (!this.isFormattable()) {
            throw new UnsupportedOperationException("The media device does not support formatting.");
        }
        if (!this.isMediaPresent()) {
            throw new NoMediaPresentException("missing media");
        }
        try {
            String[] formatCmd = new String[]{this.mediaServicesParameters.getParm("media.dvdformat.script"), this.mediaDeviceProperties.getDeviceFile(), this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log"), label};
            Trace.trace("XMDADEVF", "CdDvd.format(): formatCmd[0] = " + formatCmd[0]);
            Trace.trace("XMDADEVF", "CdDvd.format(): formatCmd[1] = " + formatCmd[1]);
            Trace.trace("XMDADEVF", "CdDvd.format(): formatCmd[2] = " + formatCmd[2]);
            Trace.trace("XMDADEVF", "CdDvd.format(): formatCmd[3] = " + formatCmd[3]);
            int rc = RootProcess.executeProgram(formatCmd);
            Trace.trace("XMDADEVF", "CdDvd.format(): rc = " + rc);
            if (rc != 0) {
                throw new IOException("failure to format DVD");
            }
        }
        catch (Exception exc) {
            Trace.trace("XMDADEVF", exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 628, mdexc).log();
            throw mdexc;
        }
        Trace.trace("XMDADEVT", "<- CdDvd.format()");
    }
}

